/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.ScriptingEngine;
import com.aptana.scripting.model.AbstractBundleElement;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleEntry;
import com.aptana.scripting.model.BundlePrecedence;
import com.aptana.scripting.model.BundleUtils;
import com.aptana.scripting.model.BundleVisibilityListener;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContentAssistElement;
import com.aptana.scripting.model.ElementVisibilityListener;
import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.model.LoadCycleListener;
import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.model.RunType;
import com.aptana.scripting.model.SmartTypingPairsElement;
import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.filters.AndFilter;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.IsExecutableCommandFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.jruby.RubyRegexp;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManager {
    private static final String STUDIO_BUNDLE_LOAD_CONCURRENCY = "studio.bundleLoadConcurrency";
    private static final String APPLICATION_BUNDLE_PATHS_ID = "applicationBundlePaths";
    private static final String TAG_BUNDLE_PATH = "bundlePath";
    private static final String ATTR_PATH = "path";
    private static final String USE_BUNDLE_CACHE = "use.bundle.cache";
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final Pattern STAR_PATTERN = Pattern.compile("\\*");
    public static final String SNIPPETS_DIRECTORY_NAME = "snippets";
    private static final String COMMANDS_DIRECTORY_NAME = "commands";
    private static final String TEMPLATES_DIRECTORY_NAME = "templates";
    private static final String SAMPLES_DIRECTORY_NAME = "samples";
    private static final String CONFIG_DIRECTORY_NAME = "config";
    private static final String LOCALES_DIRECTORY_NAME = "locales";
    private static final File[] NO_FILES = new File[0];
    private static final String BUILTIN_BUNDLES = "bundles";
    public static final String BUNDLE_FILE = "bundle.rb";
    private static final String RUBY_FILE_EXTENSION = ".rb";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_BUNDLE_DIRECTORY_GENERAL = "Aptana Rubles";
    private static final String USER_BUNDLE_DIRECTORY_MACOSX = "/Documents/Aptana Rubles";
    private static BundleManager INSTANCE;
    private int counter = 0;
    private List<String> applicationBundlesPaths;
    private String userBundlesPath;
    private Map<File, List<BundleElement>> _bundlesByPath = new HashMap<File, List<BundleElement>>();
    private Map<String, BundleEntry> _entriesByName = new HashMap<String, BundleEntry>();
    private List<BundleVisibilityListener> _bundleVisibilityListeners;
    private List<ElementVisibilityListener> _elementVisibilityListeners;
    private List<LoadCycleListener> _loadCycleListeners;
    private Map<String, String> _stringPool = new HashMap<String, String>();
    private int fBundlesToLoadInParallel = -1;

    public static BundleManager getInstance() {
        return BundleManager.getInstance(null, null);
    }

    public static synchronized BundleManager getInstance(String applicationBundlesPath, String userBundlesPath) {
        if (INSTANCE == null) {
            INSTANCE = new BundleManager();
            INSTANCE.initializeBundlePaths();
        }
        if (!StringUtil.isEmpty((String)applicationBundlesPath)) {
            BundleManager.INSTANCE.applicationBundlesPaths = CollectionsUtil.newList((Object[])new String[]{applicationBundlesPath});
        }
        if (!StringUtil.isEmpty((String)userBundlesPath)) {
            BundleManager.INSTANCE.userBundlesPath = userBundlesPath;
        }
        return INSTANCE;
    }

    private void initializeBundlePaths() {
        if (ScriptingActivator.getDefault() != null) {
            final ArrayList<String> paths = new ArrayList<String>();
            EclipseUtil.processConfigurationElements((String)"com.aptana.scripting", (String)APPLICATION_BUNDLE_PATHS_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

                public void processElement(IConfigurationElement element) {
                    String path = element.getAttribute(BundleManager.ATTR_PATH);
                    IExtension declaring = element.getDeclaringExtension();
                    String declaringPluginID = declaring.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)declaringPluginID);
                    URL url = bundle.getEntry(path);
                    String urlAsPath = ResourceUtil.resourcePathToString((URL)url);
                    if (urlAsPath != null && urlAsPath.length() > 0) {
                        paths.add(urlAsPath);
                    } else {
                        String message = MessageFormat.format("Unable to convert resource URL in plugin {0} to a string: {1}", declaringPluginID, url);
                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)message);
                    }
                }

                public Set<String> getSupportElementNames() {
                    return CollectionsUtil.newSet((Object[])new String[]{BundleManager.TAG_BUNDLE_PATH});
                }
            });
            this.applicationBundlesPaths = paths;
        }
        boolean validUserBundlePath = false;
        String userBundlePathOverride = System.getProperty("studio.rubleUserLocation");
        if (userBundlePathOverride != null) {
            File f = new File(userBundlePathOverride);
            if (f.exists()) {
                if (f.isDirectory()) {
                    if (f.canRead() && f.canWrite()) {
                        validUserBundlePath = true;
                    } else {
                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleManager_USER_PATH_NOT_READ_WRITE, f.getAbsolutePath()));
                    }
                } else {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleManager_USER_PATH_NOT_DIRECTORY, f.getAbsolutePath()));
                }
            } else {
                validUserBundlePath = f.mkdirs();
            }
            if (validUserBundlePath) {
                this.userBundlesPath = f.getAbsolutePath();
            } else {
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleManager_USER_PATH_NOT_DIRECTORY, f.getAbsolutePath()));
            }
        }
        if (!validUserBundlePath) {
            String userHome = System.getProperty(USER_HOME_PROPERTY);
            this.userBundlesPath = PlatformUtil.isMac() || PlatformUtil.isLinux() ? String.valueOf(userHome) + USER_BUNDLE_DIRECTORY_MACOSX : String.valueOf(userHome) + File.separator + USER_BUNDLE_DIRECTORY_GENERAL;
        }
    }

    static boolean isSpecialDirectory(File path) {
        boolean result = false;
        if (path != null) {
            String pathString = path.getName();
            result = COMMANDS_DIRECTORY_NAME.equals(pathString) || SNIPPETS_DIRECTORY_NAME.equals(pathString) || TEMPLATES_DIRECTORY_NAME.equals(pathString) || SAMPLES_DIRECTORY_NAME.equals(pathString);
        }
        return result;
    }

    private BundleManager() {
        this._bundleVisibilityListeners = new ArrayList<BundleVisibilityListener>();
        this._elementVisibilityListeners = new ArrayList<ElementVisibilityListener>();
        this._loadCycleListeners = new ArrayList<LoadCycleListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundle(BundleElement bundle) {
        if (bundle != null) {
            File bundleFile = bundle.getBundleDirectory();
            Map<File, List<BundleElement>> map = this._bundlesByPath;
            synchronized (map) {
                if (!this._bundlesByPath.containsKey(bundleFile)) {
                    this._bundlesByPath.put(bundleFile, CollectionsUtil.newList((Object[])new BundleElement[]{bundle}));
                } else {
                    List<BundleElement> bundles = this._bundlesByPath.get(bundleFile);
                    bundles.add(bundle);
                }
            }
            String name = bundle.getDisplayName();
            Map<String, BundleEntry> map2 = this._entriesByName;
            synchronized (map2) {
                if (!this._entriesByName.containsKey(name)) {
                    BundleEntry entry = new BundleEntry(name);
                    entry.addBundle(bundle);
                    this._entriesByName.put(name, entry);
                } else {
                    BundleEntry entry = this._entriesByName.get(name);
                    entry.addBundle(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleVisibilityListener(BundleVisibilityListener listener) {
        if (listener != null) {
            List<BundleVisibilityListener> list = this._bundleVisibilityListeners;
            synchronized (list) {
                if (!this._bundleVisibilityListeners.contains(listener)) {
                    this._bundleVisibilityListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementVisibilityListener(ElementVisibilityListener listener) {
        if (listener != null) {
            List<ElementVisibilityListener> list = this._elementVisibilityListeners;
            synchronized (list) {
                if (!this._elementVisibilityListeners.contains(listener)) {
                    this._elementVisibilityListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadCycleListener(LoadCycleListener listener) {
        if (listener != null) {
            List<LoadCycleListener> list = this._loadCycleListeners;
            synchronized (list) {
                if (!this._loadCycleListeners.contains(listener)) {
                    this._loadCycleListeners.add(listener);
                }
            }
        }
    }

    void fireBundleBecameHiddenEvent(BundleEntry entry) {
        if (entry != null) {
            for (BundleVisibilityListener listener : this.getBundleVisibilityListeners()) {
                try {
                    listener.bundlesBecameHidden(entry);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Bundle_Became_Hidden_Event_Error, (Throwable)t);
                }
            }
        }
    }

    void fireBundleBecameVisibleEvent(BundleEntry entry) {
        if (entry != null) {
            for (BundleVisibilityListener listener : this.getBundleVisibilityListeners()) {
                try {
                    listener.bundlesBecameVisible(entry);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Bundle_Became_Visible_Event_Error, (Throwable)t);
                }
            }
        }
    }

    void fireElementBecameHiddenEvent(AbstractElement element) {
        if (element != null) {
            for (ElementVisibilityListener listener : this.getElementVisibilityListeners()) {
                try {
                    listener.elementBecameHidden(element);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Element_Became_Hidden_Event_Error, (Throwable)t);
                }
            }
        }
    }

    void fireElementBecameVisibleEvent(AbstractElement element) {
        if (element != null) {
            for (ElementVisibilityListener listener : this.getElementVisibilityListeners()) {
                try {
                    listener.elementBecameVisible(element);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Element_Became_Visible_Event_Error, (Throwable)t);
                }
            }
        }
    }

    void fireScriptLoadedEvent(File script) {
        if (script != null) {
            for (LoadCycleListener listener : this.getLoadCycleListeners()) {
                try {
                    listener.scriptLoaded(script);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Script_Loaded_Event_Error, (Throwable)t);
                }
            }
        }
    }

    void fireScriptReloadedEvent(File script) {
        if (script != null) {
            for (LoadCycleListener listener : this.getLoadCycleListeners()) {
                try {
                    listener.scriptReloaded(script);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Script_Reloaded_Event_Error, (Throwable)t);
                }
            }
        }
    }

    void fireScriptUnloadedEvent(File script) {
        if (script != null) {
            for (LoadCycleListener listener : this.getLoadCycleListeners()) {
                try {
                    listener.scriptUnloaded(script);
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleManager_Script_Unloaded_Event_Error, (Throwable)t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BundleElement> getApplicationBundles() {
        ArrayList<BundleElement> result = new ArrayList<BundleElement>();
        if (this.applicationBundlesPaths != null) {
            HashSet<File> keys;
            Map<File, List<BundleElement>> map = this._bundlesByPath;
            synchronized (map) {
                keys = new HashSet<File>(this._bundlesByPath.keySet());
            }
            HashSet<File> applicationKeys = new HashSet<File>();
            for (File key : keys) {
                String path = key.getAbsolutePath();
                for (String applicationBundlesPath : this.applicationBundlesPaths) {
                    if (!path.startsWith(applicationBundlesPath)) continue;
                    applicationKeys.add(key);
                }
            }
            for (File key : applicationKeys) {
                result.add(this.getBundleFromPath(key));
            }
        }
        return result;
    }

    List<String> getApplicationBundlesPaths() {
        return this.applicationBundlesPaths;
    }

    public List<CommandElement> getBundleCommands(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getCommands();
        }
        return Collections.emptyList();
    }

    public List<ContentAssistElement> getBundleContentAssists(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getContentAssists();
        }
        return Collections.emptyList();
    }

    protected List<File> getBundleDirectories(File bundlesDirectory) {
        File[] result = NO_FILES;
        if (bundlesDirectory != null && bundlesDirectory.isDirectory() && bundlesDirectory.canRead()) {
            result = bundlesDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory() && !pathname.getName().startsWith(".") && BundleManager.this.isValidBundleDirectory(pathname);
                }
            });
        }
        return Arrays.asList(result);
    }

    public File getBundleDirectory(File script) {
        File result = null;
        if (script != null) {
            IPath path = Path.fromOSString((String)script.getAbsolutePath());
            if (script.isFile()) {
                path = path.removeLastSegments(1);
            }
            File file = path.toFile();
            while (true) {
                if (this.isValidBundleDirectory(file)) {
                    return file;
                }
                if (path.segmentCount() == 0) break;
                path = path.removeLastSegments(1);
                file = path.toFile();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleEntry getBundleEntry(String name) {
        Map<String, BundleEntry> map = this._entriesByName;
        synchronized (map) {
            return this._entriesByName.get(name);
        }
    }

    public List<EnvironmentElement> getBundleEnvs(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getEnvs();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleElement getBundleFromPath(File bundleDirectory) {
        int size;
        ArrayList bundles = null;
        BundleElement result = null;
        Map<File, List<BundleElement>> map = this._bundlesByPath;
        synchronized (map) {
            if (this._bundlesByPath.containsKey(bundleDirectory)) {
                bundles = new ArrayList(this._bundlesByPath.get(bundleDirectory));
            }
        }
        if (bundles != null && (size = bundles.size()) > 0) {
            result = (BundleElement)bundles.get(size - 1);
        }
        return result;
    }

    public BundleElement getBundleFromPath(String path) {
        if (path != null) {
            return this.getBundleFromPath(new File(path));
        }
        return null;
    }

    protected List<String> getBundleLoadPaths(File bundleDirectory) {
        List<String> result = null;
        if (bundleDirectory != null) {
            String defaultName;
            File bundleFile = new File(bundleDirectory, BUNDLE_FILE);
            String bundleName = BundleUtils.getBundleName(bundleFile);
            if (bundleName != null && !bundleName.equals(defaultName = BundleUtils.getDefaultBundleName(bundleFile.getAbsolutePath()))) {
                result = this.getBundleLoadPaths(bundleName);
            }
            if (result == null) {
                result = new ArrayList<String>(this.getScriptingEngine().getContributedLoadPaths());
            }
            result.add(0, BundleUtils.getBundleLibDirectory(bundleDirectory));
        }
        return result;
    }

    protected List<String> getBundleLoadPaths(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        ArrayList<String> result = new ArrayList<String>();
        if (entry != null) {
            result.addAll(entry.getLoadPaths());
        }
        result.addAll(this.getScriptingEngine().getContributedLoadPaths());
        return result;
    }

    public List<SnippetCategoryElement> getBundleSnippetCategories(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getSnippetCategories();
        }
        return Collections.emptyList();
    }

    public List<SnippetElement> getBundleSnippets(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getSnippets();
        }
        return Collections.emptyList();
    }

    public List<MenuElement> getBundleMenus(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getMenus();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBundleNames() {
        Map<String, BundleEntry> map = this._entriesByName;
        synchronized (map) {
            return new ArrayList<String>(this._entriesByName.keySet());
        }
    }

    public List<SmartTypingPairsElement> getBundlePairs(String name) {
        BundleEntry entry = this.getBundleEntry(name);
        if (entry != null) {
            return entry.getPairs();
        }
        return Collections.emptyList();
    }

    public BundlePrecedence getBundlePrecedence(File path) {
        return this.getBundlePrecedence(path.getAbsolutePath());
    }

    public BundlePrecedence getBundlePrecedence(String path) {
        if (path != null && this.applicationBundlesPaths != null) {
            for (String applicationBundlesPath : this.applicationBundlesPaths) {
                if (!path.startsWith(applicationBundlesPath)) continue;
                return BundlePrecedence.APPLICATION;
            }
            if (this.userBundlesPath != null && path.startsWith(this.userBundlesPath)) {
                return BundlePrecedence.USER;
            }
        }
        return BundlePrecedence.PROJECT;
    }

    protected List<File> getBundleScripts(File bundleDirectory) {
        ArrayList<File> result = new ArrayList<File>();
        if (this.isValidBundleDirectory(bundleDirectory)) {
            File bundleFile = new File(bundleDirectory, BUNDLE_FILE);
            if (bundleFile.exists()) {
                result.add(bundleFile);
            }
            File commandsDirectory = new File(bundleDirectory, COMMANDS_DIRECTORY_NAME);
            result.addAll(this.getScriptsFromDirectory(commandsDirectory));
            File snippetsDirectory = new File(bundleDirectory, SNIPPETS_DIRECTORY_NAME);
            result.addAll(this.getScriptsFromDirectory(snippetsDirectory));
            File templatesDirectory = new File(bundleDirectory, TEMPLATES_DIRECTORY_NAME);
            result.addAll(this.getScriptsFromDirectory(templatesDirectory));
            File samplesDirectory = new File(bundleDirectory, SAMPLES_DIRECTORY_NAME);
            result.addAll(this.getScriptsFromDirectory(samplesDirectory));
        }
        return result;
    }

    protected List<File> localizationFiles(File bundleDirectory) {
        File directory;
        if (this.isValidBundleDirectory(bundleDirectory) && (directory = new File(new File(bundleDirectory, CONFIG_DIRECTORY_NAME), LOCALES_DIRECTORY_NAME)) != null && directory.exists() && directory.canRead()) {
            File[] ymlFiles = directory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".yml");
                }
            });
            return Arrays.asList(ymlFiles);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BundleVisibilityListener> getBundleVisibilityListeners() {
        List<BundleVisibilityListener> list = this._bundleVisibilityListeners;
        synchronized (list) {
            return new ArrayList<BundleVisibilityListener>(this._bundleVisibilityListeners);
        }
    }

    public List<CommandElement> getCommands() {
        return this.getCommands(null);
    }

    public List<CommandElement> getCommands(IModelFilter filter) {
        ArrayList<CommandElement> result = new ArrayList<CommandElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundleCommands(name), result, (IFilter)filter);
        }
        return result;
    }

    public List<ContentAssistElement> getContentAssists(IModelFilter filter) {
        ArrayList<ContentAssistElement> result = new ArrayList<ContentAssistElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundleContentAssists(name), result, (IFilter)filter);
        }
        return result;
    }

    public RubyRegexp getDecreaseIndentRegexp(String scope) {
        HashMap<ScopeSelector, RubyRegexp> map = new HashMap<ScopeSelector, RubyRegexp>();
        for (String bundleName : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(bundleName);
            map.putAll(bundleEntry.getDecreaseIndentMarkers());
        }
        if (map.isEmpty()) {
            return null;
        }
        IScopeSelector bestMatch = ScopeSelector.bestMatch(map.keySet(), scope);
        if (bestMatch == null) {
            return null;
        }
        return (RubyRegexp)map.get(bestMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ElementVisibilityListener> getElementVisibilityListeners() {
        List<ElementVisibilityListener> list = this._elementVisibilityListeners;
        synchronized (list) {
            return new ArrayList<ElementVisibilityListener>(this._elementVisibilityListeners);
        }
    }

    public List<EnvironmentElement> getEnvs(IModelFilter filter) {
        ArrayList<EnvironmentElement> result = new ArrayList<EnvironmentElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundleEnvs(name), result, (IFilter)filter);
        }
        return result;
    }

    public List<CommandElement> getExecutableCommands(IModelFilter filter) {
        IsExecutableCommandFilter executableFilter = new IsExecutableCommandFilter();
        filter = filter == null ? executableFilter : new AndFilter(filter, executableFilter);
        return this.getCommands(filter);
    }

    public RubyRegexp getFoldingStartRegexp(String scope) {
        HashMap<ScopeSelector, RubyRegexp> map = new HashMap<ScopeSelector, RubyRegexp>();
        for (String bundleName : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(bundleName);
            map.putAll(bundleEntry.getFoldingStartMarkers());
        }
        if (map.isEmpty()) {
            return null;
        }
        IScopeSelector bestMatch = ScopeSelector.bestMatch(map.keySet(), scope);
        if (bestMatch == null) {
            return null;
        }
        return (RubyRegexp)map.get(bestMatch);
    }

    public RubyRegexp getFoldingStopRegexp(String scope) {
        HashMap<ScopeSelector, RubyRegexp> map = new HashMap<ScopeSelector, RubyRegexp>();
        for (String bundleName : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(bundleName);
            map.putAll(bundleEntry.getFoldingStopMarkers());
        }
        if (map.isEmpty()) {
            return null;
        }
        IScopeSelector bestMatch = ScopeSelector.bestMatch(map.keySet(), scope);
        if (bestMatch == null) {
            return null;
        }
        return (RubyRegexp)map.get(bestMatch);
    }

    public RubyRegexp getIncreaseIndentRegexp(String scope) {
        HashMap<ScopeSelector, RubyRegexp> map = new HashMap<ScopeSelector, RubyRegexp>();
        for (String bundleName : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(bundleName);
            map.putAll(bundleEntry.getIncreaseIndentMarkers());
        }
        if (map.isEmpty()) {
            return null;
        }
        IScopeSelector bestMatch = ScopeSelector.bestMatch(map.keySet(), scope);
        if (bestMatch == null) {
            return null;
        }
        return (RubyRegexp)map.get(bestMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LoadCycleListener> getLoadCycleListeners() {
        List<LoadCycleListener> list = this._loadCycleListeners;
        synchronized (list) {
            return new ArrayList<LoadCycleListener>(this._loadCycleListeners);
        }
    }

    public List<MenuElement> getMenus(IModelFilter filter) {
        ArrayList<MenuElement> result = new ArrayList<MenuElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundleMenus(name), result, (IFilter)filter);
        }
        return result;
    }

    public List<SmartTypingPairsElement> getPairs(IModelFilter filter) {
        ArrayList<SmartTypingPairsElement> result = new ArrayList<SmartTypingPairsElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundlePairs(name), result, (IFilter)filter);
        }
        return result;
    }

    public List<ProjectTemplateElement> getProjectTemplates(IModelFilter filter) {
        ArrayList<ProjectTemplateElement> result = new ArrayList<ProjectTemplateElement>();
        for (String name : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(name);
            CollectionsUtil.filter(bundleEntry.getProjectTemplates(), result, (IFilter)filter);
        }
        return result;
    }

    public List<ProjectSampleElement> getProjectSamples(IModelFilter filter) {
        ArrayList<ProjectSampleElement> result = new ArrayList<ProjectSampleElement>();
        for (String name : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(name);
            CollectionsUtil.filter(bundleEntry.getProjectSamples(), result, (IFilter)filter);
        }
        return result;
    }

    public List<SnippetElement> getSnippets(IModelFilter filter) {
        ArrayList<SnippetElement> result = new ArrayList<SnippetElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundleSnippets(name), result, (IFilter)filter);
        }
        return result;
    }

    public List<SnippetCategoryElement> getSnippetCategories(IModelFilter filter) {
        ArrayList<SnippetCategoryElement> result = new ArrayList<SnippetCategoryElement>();
        for (String name : this.getBundleNames()) {
            CollectionsUtil.filter(this.getBundleSnippetCategories(name), result, (IFilter)filter);
        }
        return result;
    }

    protected List<File> getScriptsFromDirectory(File directory) {
        File[] result = NO_FILES;
        if (directory != null && directory.exists() && directory.canRead()) {
            result = directory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().toLowerCase().endsWith(BundleManager.RUBY_FILE_EXTENSION);
                }
            });
            Arrays.sort(result, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return Arrays.asList(result);
    }

    public String getTopLevelScope(String fileName) {
        String result = null;
        String matchedPattern = null;
        for (String bundleName : this.getBundleNames()) {
            BundleEntry bundleEntry = this.getBundleEntry(bundleName);
            Map<String, String> registry = bundleEntry.getFileTypeRegistry();
            for (Map.Entry<String, String> entry : registry.entrySet()) {
                String pattern = entry.getKey();
                pattern = DOT_PATTERN.matcher(pattern).replaceAll("\\\\.");
                if (!fileName.matches(pattern = STAR_PATTERN.matcher(pattern).replaceAll(".+?"))) continue;
                if (result == null) {
                    result = entry.getValue();
                    matchedPattern = pattern;
                    continue;
                }
                int existingLength = StringUtil.characterInstanceCount(result, (char)'.') + 1;
                int newLength = StringUtil.characterInstanceCount((String)entry.getValue(), (char)'.') + 1;
                if (newLength > existingLength) {
                    result = entry.getValue();
                    matchedPattern = pattern;
                    continue;
                }
                if (newLength != existingLength || pattern.length() <= matchedPattern.length()) continue;
                result = entry.getValue();
                matchedPattern = pattern;
            }
        }
        return result;
    }

    public String getUserBundlesPath() {
        return this.userBundlesPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBundleAtPath(File bundleDirectory) {
        Map<File, List<BundleElement>> map = this._bundlesByPath;
        synchronized (map) {
            return this._bundlesByPath.containsKey(bundleDirectory);
        }
    }

    protected boolean isUserBundleDirectory(File bundleDirectory) {
        if (bundleDirectory != null) {
            return this.getBundlePrecedence(bundleDirectory) == BundlePrecedence.USER;
        }
        return false;
    }

    protected boolean isValidBundleDirectory(File bundleDirectory) {
        File bundleFile;
        return bundleDirectory.isDirectory() && bundleDirectory.canRead() && (bundleFile = new File(bundleDirectory.getAbsolutePath(), BUNDLE_FILE)).isFile();
    }

    protected void loadApplicationBundles() {
        if (this.applicationBundlesPaths != null) {
            for (String applicationBundle : this.applicationBundlesPaths) {
                File applicationBundlesDirectory = new File(applicationBundle);
                for (File bundle : this.getBundleDirectories(applicationBundlesDirectory)) {
                    this.loadBundle(bundle);
                }
            }
        }
    }

    public void loadBundle(File bundleDirectory) {
        this.loadBundle(bundleDirectory, false);
    }

    public void loadBundle(File bundleDirectory, boolean wait) {
        BundleLoadJob job = new BundleLoadJob(bundleDirectory);
        if (!EclipseUtil.isTesting() && Platform.isRunning()) {
            job.setRule(new SerialPerObjectRule(this.counter++));
            if (this.counter >= this.maxBundlesToLoadInParallel()) {
                this.counter = 0;
            }
            job.setPriority(20);
            job.schedule();
            if (wait) {
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            job.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected synchronized int maxBundlesToLoadInParallel() {
        if (this.fBundlesToLoadInParallel < 0) {
            this.fBundlesToLoadInParallel = Runtime.getRuntime().availableProcessors();
            String max = System.getProperty(STUDIO_BUNDLE_LOAD_CONCURRENCY);
            if (!StringUtil.isEmpty((String)max)) {
                try {
                    this.fBundlesToLoadInParallel = Integer.parseInt(max);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.fBundlesToLoadInParallel = Math.max(1, this.fBundlesToLoadInParallel);
        }
        return this.fBundlesToLoadInParallel;
    }

    public void loadBundles() {
        this.reset();
        this.loadApplicationBundles();
        this.loadUserBundles();
        this.loadProjectBundles();
    }

    protected void loadProjectBundles() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath location = project.getLocation();
            if (location != null) {
                File projectDirectory = location.toFile();
                File bundlesDirectory = new File(projectDirectory.getAbsolutePath(), BUILTIN_BUNDLES);
                for (File bundle : this.getBundleDirectories(bundlesDirectory)) {
                    String message = MessageFormat.format(Messages.BundleManager_ProjectBundlesInBundlesDirectoryIsDeprecated, bundle.getAbsolutePath());
                    ScriptLogger.logWarning(message);
                    IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)message);
                    this.loadBundle(bundle);
                }
                if (!this.isUserBundleDirectory(projectDirectory) && this.isValidBundleDirectory(projectDirectory)) {
                    this.loadBundle(projectDirectory);
                }
            }
            ++n2;
        }
    }

    public void loadScript(File script) {
        this.loadScript(script, true);
    }

    public void loadScript(File script, boolean fireEvent) {
        if (script != null) {
            File bundleDirectory = this.getBundleDirectory(script);
            List<String> bundleLoadPaths = this.getBundleLoadPaths(bundleDirectory);
            this.loadScript(script, fireEvent, bundleLoadPaths);
        }
    }

    public void loadScript(File script, boolean fireEvent, List<String> loadPaths) {
        if (script == null) {
            ScriptLogger.logError(Messages.BundleManager_Executed_Null_Script);
            return;
        }
        if (!script.canRead()) {
            ScriptLogger.logError(MessageFormat.format(Messages.BundleManager_UNREADABLE_SCRIPT, script.getAbsolutePath()));
            return;
        }
        this.showBundleLoadInfo(MessageFormat.format("Loading script: {0}, fire event={1}", script, fireEvent));
        this.getScriptingEngine().runScript(script.getAbsolutePath(), loadPaths);
        this.showBundleLoadInfo(MessageFormat.format("Loading complete: {0}", script));
        if (fireEvent) {
            this.fireScriptLoadedEvent(script);
        }
    }

    protected void loadUserBundles() {
        String userBundles = this.getUserBundlesPath();
        if (userBundles != null) {
            File userBundlesDirectory = new File(userBundles);
            for (File bundle : this.getBundleDirectories(userBundlesDirectory)) {
                this.loadBundle(bundle);
            }
        }
    }

    public void reloadBundle(BundleElement bundle) {
        if (bundle != null) {
            File bundleDirectory = bundle.getBundleDirectory();
            this.unloadBundle(bundleDirectory);
            this.loadBundle(bundleDirectory);
        }
    }

    public void reloadScript(File script) {
        if (script == null) {
            ScriptLogger.logError(Messages.BundleManager_Reloaded_Null_Script);
            return;
        }
        this.unloadScript(script, false);
        File bundleDirectory = this.getBundleDirectory(script);
        List<String> loadPaths = this.getBundleLoadPaths(bundleDirectory);
        this.getScriptingEngine().runScript(script.getAbsolutePath(), loadPaths, RunType.THREAD, false);
        this.fireScriptReloadedEvent(script);
    }

    protected ScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBundle(BundleElement bundle) {
        if (bundle != null) {
            File bundleFile = bundle.getBundleDirectory();
            String name = bundle.getDisplayName();
            Map<Object, Object> map = this._bundlesByPath;
            synchronized (map) {
                if (this._bundlesByPath.containsKey(bundleFile)) {
                    List<BundleElement> bundles = this._bundlesByPath.get(bundleFile);
                    bundles.remove(bundle);
                    if (bundles.size() == 0) {
                        this._bundlesByPath.remove(bundleFile);
                    }
                }
            }
            map = this._entriesByName;
            synchronized (map) {
                if (this._entriesByName.containsKey(name)) {
                    BundleEntry entry = this._entriesByName.get(name);
                    entry.removeBundle(bundle);
                    if (entry.size() == 0) {
                        this._entriesByName.remove(name);
                    }
                }
            }
            AbstractElement.unregisterElement(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleVisibilityListener(BundleVisibilityListener listener) {
        List<BundleVisibilityListener> list = this._bundleVisibilityListeners;
        synchronized (list) {
            this._bundleVisibilityListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementVisibilityListener(ElementVisibilityListener listener) {
        List<ElementVisibilityListener> list = this._elementVisibilityListeners;
        synchronized (list) {
            this._elementVisibilityListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadCycleListener(LoadCycleListener listener) {
        List<LoadCycleListener> list = this._loadCycleListeners;
        synchronized (list) {
            this._loadCycleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<Object, Object> map = this._bundlesByPath;
        synchronized (map) {
            this._bundlesByPath.clear();
        }
        map = this._entriesByName;
        synchronized (map) {
            this._entriesByName.clear();
        }
    }

    public void setUseCache(boolean value) {
        System.setProperty(USE_BUNDLE_CACHE, Boolean.toString(value));
    }

    protected void showBundleLoadInfo(String message) {
        IdeLog.logInfo((Plugin)ScriptingActivator.getDefault(), (String)message, (String)"com.aptana.scripting/debug/show_bundle_load_info");
    }

    public void unloadBundle(File bundleDirectory) {
        List<AbstractElement> elements = AbstractElement.getElementsByDirectory(bundleDirectory.getAbsolutePath());
        HashSet<File> scripts = new HashSet<File>();
        if (elements != null) {
            for (AbstractElement element : elements) {
                scripts.add(new File(element.getPath()));
            }
        }
        ArrayList reverseOrder = new ArrayList(scripts);
        Collections.sort(reverseOrder, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.getAbsolutePath().compareToIgnoreCase(o1.getAbsolutePath());
            }
        });
        for (File script : reverseOrder) {
            this.showBundleLoadInfo("Unload script: " + script.toString());
            this.unloadScript(script);
        }
    }

    public void unloadScript(File script) {
        this.unloadScript(script, true);
    }

    public void unloadScript(File script, boolean fireEvent) {
        if (script == null) {
            ScriptLogger.logError(Messages.BundleManager_Unloaded_Null_Script);
            return;
        }
        String scriptPath = script.getAbsolutePath();
        List<AbstractElement> elements = AbstractElement.getElementsByPath(scriptPath);
        for (AbstractElement element : elements) {
            AbstractBundleElement bundleElement;
            BundleElement bundle;
            if (!(element instanceof AbstractBundleElement) || (bundle = (bundleElement = (AbstractBundleElement)element).getOwningBundle()) == null) continue;
            bundle.removeChild(bundleElement);
        }
        for (AbstractElement element : elements) {
            if (!(element instanceof BundleElement)) continue;
            BundleElement bundle = (BundleElement)element;
            bundle.clearMetadata();
            if (!bundle.isEmpty()) continue;
            this.removeBundle(bundle);
        }
        if (fireEvent) {
            this.fireScriptUnloadedEvent(script);
        }
    }

    public boolean useCache() {
        return Boolean.valueOf(System.getProperty(USE_BUNDLE_CACHE, Boolean.TRUE.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String sharedString(String value) {
        if (value == null) {
            return null;
        }
        Map<String, String> map = this._stringPool;
        synchronized (map) {
            String result = this._stringPool.get(value);
            if (result != null) {
                return result;
            }
            this._stringPool.put(value, value);
        }
        return value;
    }

    private class BundleLoadJob
    extends Job {
        private File bundleDirectory;

        BundleLoadJob(File bundleDirectory) {
            super("Loading bundle: " + bundleDirectory.getAbsolutePath());
            this.bundleDirectory = bundleDirectory;
            this.setPriority(20);
        }

        public IStatus run(IProgressMonitor monitor) {
            List<File> bundleScripts = BundleManager.this.getBundleScripts(this.bundleDirectory);
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(bundleScripts.size() + 1));
            try {
                if (bundleScripts.size() > 0) {
                    BundleManager.this.showBundleLoadInfo("cached failed, loading files directly: " + this.bundleDirectory);
                    List<String> bundleLoadPaths = BundleManager.this.getBundleLoadPaths(this.bundleDirectory);
                    File bundleScript = bundleScripts.get(0);
                    sub.subTask(bundleScript.getAbsolutePath());
                    BundleManager.this.loadScript(bundleScript, true, bundleLoadPaths);
                    sub.worked(1);
                    bundleScripts = BundleManager.this.getBundleScripts(this.bundleDirectory);
                    if (bundleScripts.size() > 0) {
                        bundleScripts.remove(0);
                        for (File script : bundleScripts) {
                            sub.subTask(script.getAbsolutePath());
                            BundleManager.this.loadScript(script, true, bundleLoadPaths);
                            sub.worked(1);
                        }
                    }
                }
            }
            finally {
                sub.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class SerialPerObjectRule
    implements ISchedulingRule {
        private Object fObject = null;

        public SerialPerObjectRule(Object lock) {
            this.fObject = lock;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof SerialPerObjectRule) {
                SerialPerObjectRule vup = (SerialPerObjectRule)rule;
                return this.fObject == vup.fObject;
            }
            return false;
        }
    }
}

